<?php
include('includes/web_header.php');
include('includes/db.php'); // PDO connection

// ==================== Fetch only 3 latest services ====================
$stmt = $pdo->prepare("SELECT * FROM services WHERE status='enabled' ORDER BY created_at DESC LIMIT 3");
$stmt->execute();
$services = $stmt->fetchAll();

// ==================== Patients Count ====================
$patient_start = 6825; 
$total_patients = $pdo->query("SELECT COUNT(*) FROM patients")->fetchColumn();
$display_patients = $patient_start + $total_patients;

// ==================== Visits Count ====================
$visit_start = 8560; 
$total_visits = $pdo->query("SELECT COUNT(*) FROM visits")->fetchColumn();
$display_visits = $visit_start + $total_visits;

// ==================== Years of Experience ====================
$start_month = 'From Septembre';
$start_year = 2022;
$current_year = date('Y'); 
$years_experience = $current_year - $start_year;

// ==================== Fetch Team Members ====================
$team_stmt = $pdo->query("SELECT * FROM team_members WHERE status='active' ORDER BY is_ceo DESC, id ASC LIMIT 4");
$team_members = $team_stmt->fetchAll();

// Separate CEO and other members
$ceo = null;
$members = [];
foreach ($team_members as $member) {
    if ($member['is_ceo']) {
        $ceo = $member;
    } else {
        $members[] = $member;
    }
}


$stmt = $pdo->prepare("
    SELECT title, description, image_1, image_2, image_3
    FROM page_content
    WHERE page = :page
    LIMIT 1
");
$stmt->execute(['page' => 'about']);
$content = $stmt->fetch(PDO::FETCH_ASSOC) ?: [];

// Safe defaults
$title = $content['title'] ?? 'Trusted Medical Experts';
$description = $content['description'] ?? '';

// Images (kept in fixed order)
$image_1 = $content['image_1'] ?? '';
$image_2 = $content['image_2'] ?? '';
$image_3 = $content['image_3'] ?? '';

?>

<!-- Navbar Start -->
<div class="container-fluid sticky-top">
    <?php include('includes/web_navbar.php'); ?>
</div>
<!-- Navbar End -->

<!-- Carousel Start -->
<div class="container-fluid header-carousel px-0 mb-5" style="height: 500px;">
    <div id="header-carousel" class="carousel slide carousel-fade h-100" data-bs-ride="carousel">
        <div class="carousel-inner h-100">
            <div class="carousel-item active h-100">
                <img class="w-100 h-100" src="asset/img/carousel-1.jpg" alt="Image" style="object-fit: cover;">
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row justify-content-start">
                            <div class="col-lg-7 text-start">
                                <h1 class="display-4 text-white animated slideInRight mb-3">Award Winning Laboratory Center</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="carousel-item h-100">
                <img class="w-100 h-100" src="asset/img/carousel-2.jpg" alt="Image" style="object-fit: cover;">
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row justify-content-end">
                            <div class="col-lg-7 text-end">
                                <h1 class="display-4 text-white animated slideInLeft mb-3">Expert Doctors & Lab Assistants</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#header-carousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#header-carousel" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>
</div>
<!-- Carousel End -->

<!-- About Start -->
<div class="container-fluid py-5">
    <div class="container pb-5">
        <div class="row g-5">
            <div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s">
                <div class="row g-0">
                    <div class="col-6">
                        <?php if ($image_1): ?>
                            <img class="img-fluid" src="<?= htmlspecialchars($image_1) ?>">
                        <?php endif; ?>
                    </div>
                    
                    <div class="col-6">
                        <?php if ($image_2): ?>
                            <img class="img-fluid" src="<?= htmlspecialchars($image_2) ?>">
                        <?php endif; ?>
                    </div>
                    
                    <div class="col-6">
                        <?php if ($image_3): ?>
                            <img class="img-fluid" src="<?= htmlspecialchars($image_3) ?>">
                        <?php endif; ?>
                    </div>
                    <div class="col-6">
                        <div class="bg-primary w-100 h-100 mt-n5 ms-n5 d-flex flex-column align-items-center justify-content-center">
                            <div class="icon-box-light"><i class="bi bi-award text-dark"></i></div>
                            <h1 class="display-1 text-white mb-0" data-toggle="counter-up"><?php echo $years_experience; ?></h1>
                            <small class="fs-5 text-white">Years Experience</small>
                            <small class="fs-6 text-white mt-1"><?php echo $start_month . ' ' . $start_year; ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
                <h1 class="display-6 mb-4">
                <?= htmlspecialchars($title) ?>
                </h1>
                
                <p class="mb-4 text-dark">
                    <?= nl2br(htmlspecialchars($description)) ?>
                </p>
                <a href="about.php" class="btn btn-primary py-3 px-5 animated slideInLeft">Read More</a>
                <div class="row g-4 g-sm-5 justify-content-center mt-4">
                    <div class="col-sm-6">
                        <div class="about-fact btn-square flex-column rounded-circle bg-primary ms-sm-auto">
                            <p class="text-white mb-0">Health Promotion <br>Campaigns Conducted</p>
                            <h1 class="text-white mb-0" data-toggle="counter-up">9</h1>
                        </div>
                    </div>
                    <div class="col-sm-6 text-start">
                        <div class="about-fact btn-square flex-column rounded-circle bg-secondary me-sm-auto">
                            <p class="text-white mb-0">Total Patients</p>
                            <h1 class="text-white mb-0" data-toggle="counter-up"><?php echo $display_patients; ?></h1>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="about-fact mt-n130 btn-square flex-column rounded-circle bg-dark mx-sm-auto">
                            <p class="text-white mb-0">Total Visits</p>
                            <h1 class="text-white mb-0" data-toggle="counter-up"><?php echo $display_visits; ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- About End -->

<!-- Services Start -->
<div class="container-fluid container-service py-5">
    <div class="container pt-5">
        <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
            <h1 class="display-6 mb-3">We provide comprehensive medical services</h1>
            <p class="mb-5">We provide comprehensive Medical Servicess using state-of-the-art technology and expert analysis.</p>
        </div>

        <div class="row g-4">
            <?php
            if(count($services) > 0) {
                $count = 0;
                foreach($services as $service) {
                    $count++;
                    $delay = 0.1 + (($count % 4) * 0.2);
                    if($delay > 0.7) $delay = 0.7;

                    // Truncate description to 20 words (like team section)
                    $desc_words = str_word_count(strip_tags($service['description']), 1);
                    $short_desc = implode(' ', array_slice($desc_words, 0, 20));
                    $is_truncated = count($desc_words) > 20;
                    
                    if ($is_truncated) {
                        $short_desc .= '...';
                    }

                    $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
            ?>
            <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s">
                <div class="service-item">
                    <div class="position-relative overflow-hidden mb-3">
                        <img class="img-fluid w-100 rounded" src="<?php echo htmlspecialchars($image_path); ?>" alt="<?php echo htmlspecialchars($service['title']); ?>" style="height: 200px; object-fit: cover;">
                    </div>
                    <h5 class="mb-3 service-title"><?php echo htmlspecialchars($service['title']); ?></h5>
                    <p class="service-desc mb-3">
                        <?php echo nl2br(htmlspecialchars($short_desc)); ?>
                    </p>
                    <?php if($is_truncated): ?>
                    <button class="btn btn-outline-primary btn-sm read-more-btn" data-bs-toggle="modal" data-bs-target="#serviceModal<?php echo $service['id']; ?>">
                        Read More <i class="bi bi-chevron-double-right ms-1"></i>
                    </button>
                    <?php else: ?>
                    <button class="btn btn-outline-primary btn-sm read-more-btn" data-bs-toggle="modal" data-bs-target="#serviceModal<?php echo $service['id']; ?>">
                        View Details <i class="bi bi-info-circle ms-1"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php
                }
            } else {
            ?>
            <div class="col-12 text-center">
                <div class="alert alert-info">
                    <h5>No services available at the moment.</h5>
                    <p>Please check back later for our service offerings.</p>
                </div>
            </div>
            <?php } ?>
        </div>

        <div class="text-center mt-5">
            <a href="service.php" class="btn btn-primary btn-lg py-3 px-5 explore-more-btn">Explore More Services</a>
        </div>
    </div>
</div>
<!-- Services End -->

<!-- Service Modals -->
<?php foreach($services as $service): 
    $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
?>
<div class="modal fade" id="serviceModal<?php echo $service['id']; ?>" tabindex="-1" aria-labelledby="serviceModalLabel<?php echo $service['id']; ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel<?php echo $service['id']; ?>"><?php echo htmlspecialchars($service['title']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-5">
                        <img src="<?php echo htmlspecialchars($image_path); ?>" class="img-fluid rounded mb-3" alt="<?php echo htmlspecialchars($service['title']); ?>" style="max-height: 300px; object-fit: cover; width: 100%;">
                    </div>
                    <div class="col-md-7">
                        <h6 class="text-primary mb-3">Service Overview</h6>
                        <div class="service-full-desc mb-4">
                            <?php echo nl2br(htmlspecialchars($service['description'])); ?>
                        </div>
                        
                        <?php if(!empty($service['detail'])): ?>
                        <h6 class="text-primary mb-3">Detailed Information</h6>
                        <div class="service-full-detail">
                            <?php echo $service['detail']; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>

<style>
/* Service Item Styling */
.service-item {
    transition: all 0.3s ease;
    border: 1px solid #eee;
    border-radius: 8px;
    overflow: hidden;
    padding: 1.5rem;
    height: 100%;
    display: flex;
    flex-direction: column;
    background: white;
}

.service-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    background-color: #0d6efd !important; /* Blue background on hover */
}

/* Title and description color changes on hover */
.service-item:hover .service-title {
    color: white !important;
}

.service-item:hover .service-desc {
    color: white !important;
}

/* Description styling */
.service-desc {
    min-height: 80px;
    overflow: hidden;
    line-height: 1.6;
    color: #666;
    font-size: 0.95rem;
    transition: color 0.3s ease;
}

.service-title {
    color: #2c3e50;
    transition: color 0.3s ease;
}

.service-full-desc,
.service-full-detail {
    line-height: 1.8;
    color: #555;
}

/* Read More Button Styling - White text on blue background by default */
.read-more-btn {
    border-color: #0d6efd;
    color: #0d6efd;
    background-color: transparent;
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 4px;
    transition: all 0.3s ease;
    border-width: 2px;
    margin-top: auto; /* Push button to bottom */
}

/* Button on hover (when service card has blue background) */
.service-item:hover .read-more-btn {
    background-color: white !important;
    color: #0d6efd !important;
    border-color: white !important;
}

/* Button hover state (when service card doesn't have blue background) */
.service-item:not(:hover) .read-more-btn:hover {
    background-color: #0d6efd !important;
    color: white !important;
    border-color: #0d6efd !important;
}

.read-more-btn:active,
.read-more-btn:focus {
    outline: none;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25) !important;
}

/* Icon color changes */
.service-item:hover .read-more-btn i {
    color: #0d6efd !important;
}

.service-item:not(:hover) .read-more-btn:hover i {
    color: white !important;
}

/* Main Explore More Button */
.explore-more-btn {
    background-color: #0d6efd;
    border-color: #0d6efd;
    transition: all 0.3s ease;
    color: white;
}

.explore-more-btn:hover {
    background-color: #0b5ed7;
    border-color: #0a58ca;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
    color: white;
}

/* Modal Styling */
.modal-content {
    border-radius: 10px;
    overflow: hidden;
}

.modal-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
    padding: 1rem 1.5rem;
}

.modal-body {
    padding: 1.5rem;
}

.modal-title {
    color: #2c3e50;
    font-weight: 600;
}

@media (max-width: 768px) {
    .service-item {
        padding: 1rem;
    }
    
    .service-item img {
        height: 180px;
    }
    
    .service-desc {
        min-height: 100px;
        font-size: 0.9rem;
    }
    
    .modal-body .row {
        flex-direction: column;
    }
    
    .modal-body .col-md-5 {
        margin-bottom: 1.5rem;
    }
    
    .read-more-btn {
        width: 100%;
        padding: 0.5rem;
    }
}
</style>

<!-- Team Start -->
<div class="container-fluid container-team py-5">
    <div class="container pb-5">
        <?php if($ceo): ?>
        <div class="row g-5 align-items-center mb-5">
            <div class="col-md-4 wow fadeIn" data-wow-delay="0.3s">
                <!-- Decreased CEO image size -->
                <div class="text-center">
                    <img class="img-fluid rounded-circle" src="<?php echo htmlspecialchars($ceo['image_path']); ?>" alt="<?php echo htmlspecialchars($ceo['name']); ?>" style="max-width: 300px; height: auto;">
                </div>
            </div>
            <div class="col-md-8 wow fadeIn" data-wow-delay="0.5s">
                <h1 class="display-6 mb-3"><?php echo htmlspecialchars($ceo['name']); ?></h1>
                <p class="lead mb-1"><strong><?php echo htmlspecialchars($ceo['role']); ?></strong></p>
                <p class="text-muted mb-4"><?php echo htmlspecialchars($ceo['location']); ?></p>
                <h3 class="mb-3">Biography</h3>
                <!-- Full biography without "Read More" -->
                <div class="ceo-bio">
                    <?php echo nl2br(htmlspecialchars($ceo['bio'])); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="row g-4">
            <?php 
            $delay = 0.1;
            foreach($members as $member): 
                // Truncate bio to 20 words
                $bio_words = str_word_count(strip_tags($member['bio']), 1);
                $short_bio = implode(' ', array_slice($bio_words, 0, 20));
                $is_truncated = count($bio_words) > 20;
                
                if ($is_truncated) {
                    $short_bio .= '...';
                }
            ?>
            <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s">
                <div class="team-item">
                    <div class="position-relative overflow-hidden">
                        <img class="img-fluid w-100 rounded" src="<?php echo htmlspecialchars($member['image_path']); ?>" alt="<?php echo htmlspecialchars($member['name']); ?>">
                    </div>
                    <div class="text-center p-4">
                        <h5 class="mb-1"><?php echo htmlspecialchars($member['name']); ?></h5>
                        <span class="text-muted d-block mb-2"><?php echo htmlspecialchars($member['role']); ?></span>
                        <?php if(!empty($member['location'])): ?>
                        <small class="text-muted d-block mb-3"><?php echo htmlspecialchars($member['location']); ?></small>
                        <?php endif; ?>
                        
                        <p class="member-bio mb-3" style="font-size: 0.9rem; color: #666;">
                            <?php echo nl2br(htmlspecialchars($short_bio)); ?>
                        </p>
                        
                        <?php if($is_truncated): ?>
                        <button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#teamMemberModal<?php echo $member['id']; ?>">
                            Read More <i class="bi bi-chevron-double-right ms-1"></i>
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php 
            $delay += 0.2;
            if($delay > 0.7) $delay = 0.7;
            endforeach; ?>
        </div>

        <!-- Explore More Button -->
        <div class="text-center mt-5">
            <a href="about.php" class="btn btn-primary btn-lg py-3 px-5">Explore More Team Members</a>
        </div>
    </div>
</div>
<!-- Team End -->

<!-- Service Modals -->
<?php foreach($services as $service): ?>
<div class="modal fade" id="serviceModal<?php echo $service['id']; ?>" tabindex="-1" aria-labelledby="serviceModalLabel<?php echo $service['id']; ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel<?php echo $service['id']; ?>"><?php echo htmlspecialchars($service['title']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php if(!empty($service['image_path'])): ?>
                <div class="text-center mb-4">
                    <img src="<?php echo htmlspecialchars($service['image_path']); ?>" class="img-fluid rounded" alt="<?php echo htmlspecialchars($service['title']); ?>" style="max-height: 300px; object-fit: cover;">
                </div>
                <?php endif; ?>
                
                <p><strong>Description:</strong></p>
                <p><?php echo nl2br(htmlspecialchars($service['description'])); ?></p>
                
                <?php if(!empty($service['detail'])): ?>
                <p><strong>Details:</strong></p>
                <div><?php echo $service['detail']; ?></div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>

<!-- Team Member Modals -->
<?php foreach($members as $member): ?>
<div class="modal fade" id="teamMemberModal<?php echo $member['id']; ?>" tabindex="-1" aria-labelledby="teamMemberModalLabel<?php echo $member['id']; ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="teamMemberModalLabel<?php echo $member['id']; ?>"><?php echo htmlspecialchars($member['name']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4 text-center">
                        <?php if(!empty($member['image_path'])): ?>
                        <img src="<?php echo htmlspecialchars($member['image_path']); ?>" class="img-fluid rounded-circle mb-3" alt="<?php echo htmlspecialchars($member['name']); ?>" style="max-width: 200px; height: auto;">
                        <?php else: ?>
                        <div class="rounded-circle bg-light d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 200px; height: 200px;">
                            <span class="text-muted">No Image</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <h5 class="text-primary"><?php echo htmlspecialchars($member['role']); ?></h5>
                        <?php if(!empty($member['location'])): ?>
                        <p class="text-muted mb-3"><i class="bi bi-geo-alt me-2"></i><?php echo htmlspecialchars($member['location']); ?></p>
                        <?php endif; ?>
                        
                        <h6 class="mt-4 mb-2">Biography</h6>
                        <div class="member-full-bio">
                            <?php echo nl2br(htmlspecialchars($member['bio'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>

<!-- Team End --> 
    <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
                <h1 class="display-6 mb-3">Our Partners</h1>
            </div>
                <div class="row g-0 feature-row">
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.3s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/britam.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.5s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/eden.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/mmi.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/prime.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/radiant.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/rssb.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/sanlam.png">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3 wow fadeIn" data-wow-delay="0.7s">
                        <div class="feature-item border h-100 p-5">
                            <img class="img-fluid" src="asset/img/insurances/uap.png">
                        </div>
                    </div>
                </div>

<style>
/* Additional styles for better appearance */
.ceo-bio {
    line-height: 1.8;
    color: #555;
}

.rounded-circle {
    border-radius: 50% !important;
}

.team-item {
    transition: transform 0.3s ease;
    border: 1px solid #eee;
    border-radius: 8px;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.team-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.team-item img {
    height: 250px;
    object-fit: cover;
}

.member-bio {
    min-height: 80px;
    overflow: hidden;
}

.member-full-bio {
    line-height: 1.8;
    color: #555;
}

.modal-content {
    border-radius: 10px;
    overflow: hidden;
}

.modal-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
}

@media (max-width: 768px) {
    .ceo-bio {
        font-size: 0.95rem;
    }
    
    .team-item img {
        height: 200px;
    }
    
    .member-bio {
        min-height: 100px;
    }
}
</style>

<?php include('includes/web_footer.php'); ?>