<?php
    include('includes/web_header.php');
    include('includes/db.php');

    // Fetch active services from database
    $services_query = "SELECT * FROM services WHERE status = 'enabled' ORDER BY created_at DESC";
    $services_result = mysqli_query($conn, $services_query);
?>

    <!-- Navbar Start -->
    <div class="container-fluid sticky-top">
        <?php include('includes/web_navbar.php'); ?>
    </div>
    <!-- Navbar End -->

   <!-- Carousel Start -->
<div class="container-fluid header-carousel px-0 mb-5" style="height: 500px;">
    <div id="header-carousel" class="carousel slide carousel-fade h-100" data-bs-ride="carousel">
        <div class="carousel-inner h-100">
            <div class="carousel-item active h-100">
                <img class="w-100 h-100" src="asset/img/carousel-1.jpg" alt="Image" style="object-fit: cover;">
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row justify-content-start">
                            <div class="col-lg-7 text-start">
                                <h1 class="display-4 text-white animated slideInRight mb-3">Award Winning Laboratory Center</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="carousel-item h-100">
                <img class="w-100 h-100" src="asset/img/carousel-2.jpg" alt="Image" style="object-fit: cover;">
                <div class="carousel-caption">
                    <div class="container">
                        <div class="row justify-content-end">
                            <div class="col-lg-7 text-end">
                                <h1 class="display-4 text-white animated slideInLeft mb-3">Expert Doctors & Lab Assistants</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#header-carousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#header-carousel" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>
</div>
<!-- Carousel End -->

    <!-- About Start -->
    <div class="container-fluid py-5">
        <div class="container pb-5">
            <div class="row g-5">
                <div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s">
                    <div class="row g-0">
                        <div class="col-6">
                            <img class="img-fluid" src="asset/img/about-1.jpg">
                        </div>
                        <div class="col-6">
                            <img class="img-fluid" src="asset/img/about-2.jpg">
                        </div>
                        <div class="col-6">
                            <img class="img-fluid" src="asset/img/about-3.jpg">
                        </div>
                        <div class="col-6">
                            <div class="bg-primary w-100 h-100 mt-n5 ms-n5 d-flex flex-column align-items-center justify-content-center">
                                <div class="icon-box-light">
                                    <i class="bi bi-award text-dark"></i>
                                </div>
                                <h1 class="display-1 text-white mb-0" data-toggle="counter-up">5</h1>
                                <small class="fs-5 text-white">Years Experience</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
                    <h1 class="display-6 mb-4">Trusted Lab Experts and Latest Lab Technologies</h1>
                    <p class="mb-4 text-dark" style="">
                        THARHON Medical Clinic (TMC) is a private healthcare facility located in Kigali City, Gasabo District, Jabana Sector, at Nyacyonga Center. TMC provides high-quality curative and preventive medical services to improve healthcare delivery in Rwanda.
                       </br>
                        <a href="about.php" class="btn btn-primary py-3 px-5 animated slideInLeft">Read More</a>
                    </p>
                    <div class="row g-4 g-sm-5 justify-content-center">
                        <div class="col-sm-6">
                            <div class="about-fact btn-square flex-column rounded-circle bg-primary ms-sm-auto">
                                <p class="text-white mb-0">Awards Winning</p>
                                <h1 class="text-white mb-0" data-toggle="counter-up">9999</h1>
                            </div>
                        </div>
                        <div class="col-sm-6 text-start">
                            <div class="about-fact btn-square flex-column rounded-circle bg-secondary me-sm-auto">
                                <p class="text-white mb-0">Total Patients </p>
                                <h1 class="text-white mb-0" data-toggle="counter-up">305 </h1>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="about-fact mt-n130 btn-square flex-column rounded-circle bg-dark mx-sm-auto">
                                <p class="text-white mb-0">Total Visits</p>
                                <h1 class="text-white mb-0" data-toggle="counter-up">209</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->

    <!-- Service Start -->
    <div class="container-fluid container-service py-5">
        <div class="container pt-5">
            <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
                <h1 class="display-6 mb-3">Reliable & High-Quality Laboratory Service</h1>
                <p class="mb-5">We provide comprehensive laboratory services using state-of-the-art technology and expert analysis.</p>
            </div>
            <div class="row g-4">
                <?php
                if(mysqli_num_rows($services_result) > 0) {
                    $count = 0;
                    while($service = mysqli_fetch_assoc($services_result)) {
                        $count++;
                        $delay = 0.1 + (($count % 4) * 0.2);
                        if($delay > 0.7) $delay = 0.7;
                        
                        $short_desc = strlen($service['description']) > 100 
                            ? substr($service['description'], 0, 100) . '...' 
                            : $service['description'];
                        
                        $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
                ?>
                <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s">
                    <div class="service-item">
                        <h5 class="mb-3"><?php echo htmlspecialchars($service['title']); ?></h5>
                        <p class="mb-4"><?php echo htmlspecialchars($short_desc); ?></p>
                        <a class="btn btn-light px-3" href="#" 
                           data-bs-toggle="modal" 
                           data-bs-target="#serviceModal<?php echo $service['id']; ?>">
                            Read More<i class="bi bi-chevron-double-right ms-1"></i>
                        </a>
                    </div>
                </div>
                <?php
                    }
                } else {
                ?>
                <div class="col-12 text-center">
                    <div class="alert alert-info">
                        <h5>No services available at the moment.</h5>
                        <p>Please check back later for our service offerings.</p>
                    </div>
                </div>
                <?php
                }
                ?>
            </div>
        </div>
    </div>
    <!-- Service End -->

    <!-- Service Modals -->
    <?php
    // Reset pointer to beginning of result set
    mysqli_data_seek($services_result, 0);
    
    if(mysqli_num_rows($services_result) > 0) {
        while($service = mysqli_fetch_assoc($services_result)) {
            $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
    ?>
    <div class="modal fade" id="serviceModal<?php echo $service['id']; ?>" tabindex="-1" 
         aria-labelledby="serviceModalLabel<?php echo $service['id']; ?>" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="serviceModalLabel<?php echo $service['id']; ?>">
                        <?php echo htmlspecialchars($service['title']); ?>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <img src="<?php echo htmlspecialchars($image_path); ?>" 
                                 class="img-fluid rounded mb-3" 
                                 alt="<?php echo htmlspecialchars($service['title']); ?>"
                                 style="max-height: 300px; object-fit: cover; width: 100%;">
                        </div>
                        <div class="col-md-8">
                            <h6 class="text-primary">Description:</h6>
                            <p><?php echo nl2br(htmlspecialchars($service['description'])); ?></p>
                            
                            <?php if(!empty($service['detail'])): ?>
                            <h6 class="text-primary mt-4">Details:</h6>
                            <p><?php echo nl2br(htmlspecialchars($service['detail'])); ?></p>
                            <?php endif; ?>
                            
                            <div class="mt-4 pt-3 border-top">
                                <small class="text-muted">
                                    <i class="bi bi-clock me-1"></i>
                                    Last updated: <?php echo date('F j, Y', strtotime($service['updated_at'])); ?>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <a href="appointment.php?service=<?php echo urlencode($service['title']); ?>" 
                       class="btn btn-primary">
                        <i class="bi bi-calendar-plus me-1"></i>Book Appointment
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php
        }
    }
    ?>

    <!-- Appointment Start -->
    <div class="container-fluid py-5">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.1s">
                    <h1 class="display-6 mb-4">We Ensure You Will Always Get The Best Result</h1>
                    <p>Our laboratory is committed to providing accurate, timely, and reliable test results using the latest technology and following strict quality control measures.</p>
                    <p class="mb-4">All our tests are performed by certified technicians and reviewed by experienced pathologists to ensure the highest standards of accuracy and reliability.</p>
                    <div class="d-flex align-items-start wow fadeIn" data-wow-delay="0.3s">
                        <div class="icon-box-primary">
                            <i class="bi bi-geo-alt text-dark fs-1"></i>
                        </div>
                        <div class="ms-3">
                            <h5>Office Address</h5>
                            <span>Nyacyonga Center, Jabana Sector, Gasabo District, Kigali City, Rwanda</span>
                        </div>
                    </div>
                    <hr>
                    <div class="d-flex align-items-start wow fadeIn" data-wow-delay="0.4s">
                        <div class="icon-box-primary">
                            <i class="bi bi-clock text-dark fs-1"></i>
                        </div>
                        <div class="ms-3">
                            <h5>Office Time</h5>
                            <span>Mon-Sat 08:00am-6:00pm, Sun 09:00am-1:00pm</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.5s">
                    <h2 class="mb-4">Online Appointment</h2>
                    <form action="submit_appointment.php" method="POST">
                        <div class="row g-3">
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="Your Name" required>
                                    <label for="name">Your Name</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="email" class="form-control" id="mail" name="email" placeholder="Your Email" required>
                                    <label for="mail">Your Email</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="mobile" name="phone" placeholder="Your Mobile" required>
                                    <label for="mobile">Your Mobile</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <select class="form-select" id="service" name="service" required>
                                        <option value="" selected disabled>Select a Service</option>
                                        <?php
                                        // Reset pointer again for dropdown
                                        mysqli_data_seek($services_result, 0);
                                        if(mysqli_num_rows($services_result) > 0) {
                                            while($service = mysqli_fetch_assoc($services_result)) {
                                        ?>
                                        <option value="<?php echo htmlspecialchars($service['title']); ?>">
                                            <?php echo htmlspecialchars($service['title']); ?>
                                        </option>
                                        <?php
                                            }
                                        } else {
                                        ?>
                                        <option value="General Medicine">General Medicine</option>
                                        <option value="Pathology Testing">Pathology Testing</option>
                                        <option value="Microbiology Tests">Microbiology Tests</option>
                                        <option value="Biochemistry Tests">Biochemistry Tests</option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <label for="service">Choose A Service</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="appointment_date" name="appointment_date" required>
                                    <label for="appointment_date">Preferred Date</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <select class="form-select" id="appointment_time" name="appointment_time" required>
                                        <option value="" selected disabled>Select Time</option>
                                        <option value="08:00">08:00 AM</option>
                                        <option value="09:00">09:00 AM</option>
                                        <option value="10:00">10:00 AM</option>
                                        <option value="11:00">11:00 AM</option>
                                        <option value="12:00">12:00 PM</option>
                                        <option value="14:00">02:00 PM</option>
                                        <option value="15:00">03:00 PM</option>
                                        <option value="16:00">04:00 PM</option>
                                        <option value="17:00">05:00 PM</option>
                                    </select>
                                    <label for="appointment_time">Preferred Time</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-floating">
                                    <textarea class="form-control" placeholder="Leave a message here" id="message" name="message" style="height: 130px"></textarea>
                                    <label for="message">Additional Message (Optional)</label>
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button class="btn btn-primary w-100 py-3" type="submit">Submit Appointment</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Appointment Start -->

    <!-- Team Start -->
    <div class="container-fluid container-team py-5">
        <div class="container pb-5">
            <div class="row g-5 align-items-center mb-5">
                <div class="col-md-6 wow fadeIn" data-wow-delay="0.3s">
                    <img class="img-fluid w-100" src="asset/img/team-1.jpg" alt="">
                </div>
                <div class="col-md-6 wow fadeIn" data-wow-delay="0.5s">
                    <h1 class="display-6 mb-3">Dr. John Martin</h1>
                    <p class="mb-1">CEO & Founder</p>
                    <p class="mb-5">Labsky, New York, USA</p>
                    <h3 class="mb-3">Biography</h3>
                    <p class="mb-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tellus augue, iaculis id elit eget, ultrices pulvinar tortor. Quisque vel lorem porttitor, malesuada arcu quis, fringilla risus. Pellentesque eu consequat augue.</p>
                    <p class="mb-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tellus augue, iaculis id elit eget, ultrices pulvinar tortor. Quisque vel lorem porttitor, malesuada arcu quis, fringilla risus. Pellentesque eu consequat augue.</p>
                    <div class="d-flex">
                        <a class="btn btn-lg-square btn-primary me-2" href=""><i class="fab fa-facebook-f"></i></a>
                        <a class="btn btn-lg-square btn-primary me-2" href=""><i class="fab fa-twitter"></i></a>
                        <a class="btn btn-lg-square btn-primary me-2" href=""><i class="fab fa-linkedin-in"></i></a>
                        <a class="btn btn-lg-square btn-primary me-2" href=""><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="team-item">
                        <div class="position-relative overflow-hidden">
                            <img class="img-fluid w-100" src="asset/img/team-2.jpg" alt="">
                            <div class="team-social">
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-twitter"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-linkedin-in"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-youtube"></i></a>
                            </div>
                        </div>
                        <div class="text-center p-4">
                            <h5 class="mb-1">Alex Robin</h5>
                            <span>Lab Assistant</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="team-item">
                        <div class="position-relative overflow-hidden">
                            <img class="img-fluid w-100" src="asset/img/team-3.jpg" alt="">
                            <div class="team-social">
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-twitter"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-linkedin-in"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-youtube"></i></a>
                            </div>
                        </div>
                        <div class="text-center p-4">
                            <h5 class="mb-1">Andrew Bon</h5>
                            <span>Lab Assistant</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
                    <div class="team-item">
                        <div class="position-relative overflow-hidden">
                            <img class="img-fluid w-100" src="asset/img/team-4.jpg" alt="">
                            <div class="team-social">
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-twitter"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-linkedin-in"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-youtube"></i></a>
                            </div>
                        </div>
                        <div class="text-center p-4">
                            <h5 class="mb-1">Martin Tompson</h5>
                            <span>Lab Assistant</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.7s">
                    <div class="team-item">
                        <div class="position-relative overflow-hidden">
                            <img class="img-fluid w-100" src="asset/img/team-5.jpg" alt="">
                            <div class="team-social">
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-twitter"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-linkedin-in"></i></a>
                                <a class="btn btn-square btn-light mx-1" href=""><i class="fab fa-youtube"></i></a>
                            </div>
                        </div>
                        <div class="text-center p-4">
                            <h5 class="mb-1">Clarabelle Samber</h5>
                            <span>Lab Assistant</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Team End -->

<?php include('includes/web_footer.php'); ?>