<?php
// Require logged-in user — no guest fallback
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// ---------------- User & Facility Info ----------------
$currentUser    = $_SESSION['username'] ?? null;
$facility_name  = $_SESSION['facility_name'] ?? null;

// Facility must exist
if (!$facility_name) {
    $_SESSION['flash'] = [
        "message" => "No facility assigned to your account.",
        "color"   => "#dc3545"
    ];
    header("Location: dashboard.php");
    exit;
}
?>
<div class="navbar-wrapper">
    <div class="navbar-header">
        <ul class="nav navbar-nav">
            <li class="nav-item mobile-menu hidden-md-up float-xs-left">
                <a class="nav-link nav-menu-main menu-toggle hidden-xs">
                    <i class="icon-menu5 font-large-1"></i>
                </a>
            </li>

            <!-- Centered Text Logo with Icon -->
            <li class="nav-item w-100" style="text-align: center;">
                <a href="#" class="navbar-brand nav-link" style="display: inline-flex; align-items: center; justify-content: center; gap: 15px;">
                    <i class="fas fa-stethoscope" style="color: #28a745; font-size: 3rem;"></i>
                    <span style="font-weight: 900; font-size: 1.5rem;">
                        <span style="color: #ffffff;">Medi</span><span style="color: #28a745;">Prime</span>
                    </span>
                </a>
            </li>

            <li class="nav-item hidden-md-up float-xs-right">
                <a data-toggle="collapse" data-target="#navbar-mobile" class="nav-link open-navbar-container">
                    <i class="icon-ellipsis pe-2x icon-icon-rotate-right-right"></i>
                </a>
            </li>
        </ul>
    </div>

    <div class="navbar-container content container-fluid">
        <div id="navbar-mobile" class="collapse navbar-toggleable-sm">

            <ul class="nav navbar-nav">
                <li class="nav-item hidden-sm-down">
                    <a href="#" class="btn btn-success upgrade-to-pro">
                        <strong><?= strtoupper(htmlspecialchars($facility_name)) ?></strong>
                    </a>
                </li>
            </ul>

            <ul class="nav navbar-nav float-xs-right">
                
                
              <li class="dropdown dropdown-notification nav-item"><a href="#" data-toggle="dropdown" class="nav-link nav-link-label"><i class="ficon icon-bell4"></i><span class="tag tag-pill tag-default tag-danger tag-default tag-up">0</span></a>
                <ul class="dropdown-menu dropdown-menu-media dropdown-menu-right">
                  <li class="dropdown-menu-header">
                    <h6 class="dropdown-header m-0"><span class="grey darken-2">Notifications</span><span class="notification-tag tag tag-default tag-danger float-xs-right m-0">0 New</span></h6>
                  </li>
                  <li class="list-group scrollable-container"><a href="javascript:void(0)" class="list-group-item">
                      <div class="media">
                        <div class="media-left valign-middle"><i class="icon-bar-graph-2 icon-bg-circle bg-teal"></i></div>
                        <div class="media-body">
                          <h6 class="media-heading">Test</h6><small>
                            <time datetime="2015-06-11T18:29:20+08:00" class="media-meta text-muted">Test</time></small>
                        </div>
                      </div></a></li>
                  <li class="dropdown-menu-footer"><a href="javascript:void(0)" class="dropdown-item text-muted text-xs-center">Read all notifications</a></li>
                </ul>
              </li>
              <li class="dropdown dropdown-notification nav-item"><a href="#" data-toggle="dropdown" class="nav-link nav-link-label"><i class="ficon icon-mail6"></i><span class="tag tag-pill tag-default tag-info tag-default tag-up">0</span></a>
                <ul class="dropdown-menu dropdown-menu-media dropdown-menu-right">
                  <li class="dropdown-menu-header">
                    <h6 class="dropdown-header m-0"><span class="grey darken-2">Messages</span><span class="notification-tag tag tag-default tag-info float-xs-right m-0">0 New</span></h6>
                  </li>
                  <li class="list-group scrollable-container">
                      <a href="javascript:void(0)" class="list-group-item">
                          <div class="media">
                            <div class="media-left"><span class="avatar avatar-sm avatar-online rounded-circle"><img src="../../app-assets/images/portrait/small/avatar-s-1.png" alt="avatar"><i></i></span></div>
                            <div class="media-body">
                              <h6 class="media-heading">User Test</h6>
                              <p class="notification-text font-small-3 text-muted">Test</p><small>
                                <time datetime="2015-06-11T18:29:20+08:00" class="media-meta text-muted">Today</time></small>
                            </div>
                          </div>
                      </a>
                    </li>
                  <li class="dropdown-menu-footer"><a href="javascript:void(0)" class="dropdown-item text-muted text-xs-center">Read all messages</a></li>
                </ul>
              </li>
                
                <!-- USER DROPDOWN WITH USERNAME -->
                <li class="dropdown dropdown-user nav-item">
                    <a href="#" data-toggle="dropdown" class="dropdown-toggle nav-link dropdown-user-link">
                        <span style="color:black; margin-left:10px; font-weight:600;">
                            <?= htmlspecialchars($currentUser); ?>
                        </span>
                    </a>

                    <div class="dropdown-menu dropdown-menu-right">
                        <a href="" class="dropdown-item"><i class="icon-head"></i> Edit Profile</a>
                        <div class="dropdown-divider"></div>
                        <a href="logout.php" class="dropdown-item btn btn-danger text-center"> Logout <i class="icon-sign-out text-center"></i></a>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
