<?php
$currentPage = basename($_SERVER['PHP_SELF']);
$role = $_SESSION['user_role'] ?? ''; 

// Dashboard per role
$roleDashboardLinks = [
    'Super_admin'    => 'dashboard.php',
    'Admin'          => 'admin_dashboard.php',
    'Receptionist'   => 'reception_dashboard.php',
    'Doctor'         => 'doctor_dashboard.php',
    'Nurse'          => 'nurse_dashboard.php',
    'Lab_technician' => 'lab_dashboard.php',
    'Dentist' => 'dentist_dashboard.php',
    'Pharmacist'     => 'pharmacist_dashboard.php'
];

$dashboardLink = $roleDashboardLinks[$role] ?? 'dashboard.php';

// --- MENU RULES ---

// LAB TECHNICIAN → ONLY LAB ITEMS
if ($role === 'Lab_technician') {
    $roleMenu = [
        [
            'title' => 'Lab Orders',
            'link'  => 'lab_orders.php',
            'icon'  => 'icon-erlenmeyer-flask'
        ],
        [
            'title' => 'List of Lab Orders',
            'link'  => 'lab_orders_list.php',
            'icon'  => 'icon-list'
        ]
    ];

} elseif ($role === 'Pharmacist') {
    // PHARMACIST → ONLY INVENTORY
    $roleMenu = [
        [
            'title'=>'Inventory Management',
            'icon'=>'icon-archive',
            'submenu'=>[
                ['title'=>'Medical Inventory','link'=>'medical_inventory.php','icon'=>'icon-download'],
                ['title'=>'Other Inventory','link'=>'other_inventory.php','icon'=>'icon-upload']
            ]
        ]
    ];

} elseif ($role === 'Receptionist') {
    // RECEPTIONIST → Patients, Visits, Products Management, and Reports
    $roleMenu = [
        ['title'=>'All Patients','link'=>'all_patients.php','icon'=>'icon-users'],
        ['title'=>'All Visits','link'=>'all_visits.php','icon'=>'icon-medkit2'],
        [
            'title'=>'Products Management',
            'icon'=>'icon-tags',
            'submenu'=>[
                ['title'=>'Product Tariffs','link'=>'products.php','icon'=>'icon-ios-pricetags-outline'],
                ['title'=>'Drugs','link'=>'drugs.php','icon'=>'icon-pie_chart'],
                ['title'=>'Medical Acts','link'=>'medical_acts.php','icon'=>'icon-ios-pulse-strong'],
                ['title'=>'Consumables','link'=>'consumables.php','icon'=>'icon-medkit2'],
                ['title'=>'Lab Tests','link'=>'lab_tests.php','icon'=>'icon-erlenmeyer-flask'],
                ['title'=>'Imaging','link'=>'imaging.php','icon'=>'icon-photo'],
                ['title'=>'Rooms','link'=>'rooms.php','icon'=>'icon-home']  // Added Rooms for Receptionist
            ]
        ],
        [
            'title'=>'Reports',
            'icon'=>'icon-stats-dots',
            'submenu'=>[
                ['title'=>'Daily Report','link'=>'daily_report.php','icon'=>'icon-list'],
                ['title'=>'Sales Report','link'=>'sales_report.php','icon'=>'icon-stats-bars22']
            ]
        ]
    ];

} else {

    // --- BASE MENU FOR ALL OTHER ROLES ---
    $defaultMenu = [
        ['title'=>'All Patients','link'=>'all_patients.php','icon'=>'icon-users'],
        ['title'=>'All Visits','link'=>'all_visits.php','icon'=>'icon-medkit2'],
    ];

    // Hospitalization menu for Nurse, Doctor, Admin & Super Admin
    if (in_array($role, ['Nurse', 'Doctor', 'Admin', 'Super_admin'])) {
        $defaultMenu[] = [
            'title'=>'Hospitalization',
            'link'=>'admit_patient.php',
            'icon'=>'icon-bed'
        ];
    }

    // Lab menu items for Admin & Super Admin
    if (in_array($role, ['Super_admin', 'Admin'])) {
        $defaultMenu[] = [
            'title'=>'Lab Orders',
            'link'=>'lab_orders.php',
            'icon'=>'icon-erlenmeyer-flask'
        ];
        $defaultMenu[] = [
            'title'=>'List of Lab Orders',
            'link'=>'lab_orders_list.php',
            'icon'=>'icon-list'
        ];
    }

    $adminExtras = [];

    // REPORTS MENU
    $reportsSubmenu = [];

    // Daily Report → Super_admin, Admin, Receptionist
    if (in_array($role, ['Super_admin','Admin','Receptionist'])) {
        $reportsSubmenu[] = [
            'title'=>'Daily Report',
            'link'=>'daily_report.php',
            'icon'=>'icon-list'
        ];
        $reportsSubmenu[] = [
            'title'=>'Sales Report',
            'link'=>'sales_report.php',
            'icon'=>'icon-stats-bars22'
        ];
    }

    // Monthly, Billing, Sales, Insurance → Admin & Super_admin only
    if (in_array($role, ['Super_admin','Admin'])) {
        $reportsSubmenu[] = [
            'title'=>'Monthly Report',
            'link'=>'monthly_report.php',
            'icon'=>'icon-bar-chart-o'
        ];
        $reportsSubmenu[] = [
            'title'=>'Billing',
            'link'=>'billing.php',
            'icon'=>'icon-money'
        ];
        $reportsSubmenu[] = [
            'title'=>'Sales Report',
            'link'=>'sales_report.php',
            'icon'=>'icon-stats-bars22'
        ];
        $reportsSubmenu[] = [
            'title'=>'Insurance Report',
            'link'=>'insurance_report.php',
            'icon'=>'icon-paste'
        ];
    }

    // Add Reports menu only if user has at least one visible report
    if (!empty($reportsSubmenu)) {
        $adminExtras[] = [
            'title'=>'Reports',
            'icon'=>'icon-stats-dots',
            'submenu'=>$reportsSubmenu
        ];
    }

    // HMIS → Admin, Super_admin, Nurse, Doctor
    if (in_array($role, ['Admin','Super_admin','Nurse','Doctor'])) {
        $adminExtras[] = [
            'title'=>'HMIS Management',
            'icon'=>'icon-tags',
            'submenu'=>[
                ['title'=>'HMIS Report','link'=>'hmis_report.php','icon'=>'icon-list'],
                ['title'=>'HMIS Category','link'=>'hmis_category.php','icon'=>'icon-list'],
                ['title'=>'HMIS Indicator','link'=>'hmis_indicator.php','icon'=>'icon-list']
            ]
        ];
    }

    // Management menus → Admin & Super_admin only
    if (in_array($role, ['Admin','Super_admin'])) {

        $adminExtras[] = [
            'title'=>'Products Management',
            'icon'=>'icon-tags',
            'submenu'=>[
                ['title'=>'Product Tariffs','link'=>'products.php','icon'=>'icon-ios-pricetags-outline'],
                ['title'=>'Drugs','link'=>'drugs.php','icon'=>'icon-pie_chart'],
                ['title'=>'Medical Acts','link'=>'medical_acts.php','icon'=>'icon-ios-pulse-strong'],
                ['title'=>'Consumables','link'=>'consumables.php','icon'=>'icon-medkit2'],
                ['title'=>'Lab Tests','link'=>'lab_tests.php','icon'=>'icon-erlenmeyer-flask'],
                ['title'=>'Imaging','link'=>'imaging.php','icon'=>'icon-photo'],
                ['title'=>'Rooms','link'=>'rooms.php','icon'=>'icon-home']  // Added Rooms for Admin/Super_admin
            ]
        ];

        $adminExtras[] = [
            'title'=>'Inventory Management',
            'icon'=>'icon-archive',
            'submenu'=>[
                ['title'=>'Medical Inventory','link'=>'medical_inventory.php','icon'=>'icon-download'],
                ['title'=>'Other Inventory','link'=>'other_inventory.php','icon'=>'icon-upload']
            ]
        ];

        $adminExtras[] = ['title'=>'Users','link'=>'users.php','icon'=>'icon-users'];
        $adminExtras[] = ['title'=>'Departments','link'=>'departments.php','icon'=>'icon-th'];
        $adminExtras[] = ['title'=>'Insurance Partners','link'=>'insurance.php','icon'=>'icon-office'];
        $adminExtras[] = ['title'=>'About Us','link'=>'about_actions.php','icon'=>'icon-office'];
        $adminExtras[] = ['title'=>'Services','link'=>'service_actions.php','icon'=>'icon-office'];
        $adminExtras[] = ['title'=>'Team Members','link'=>'team_actions.php','icon'=>'icon-office'];
    }

    // FINAL MERGE
    $roleMenu = array_merge($defaultMenu, $adminExtras);
}
?>

<!-- RENDER MENU -->
<div class="main-menu-content">
  <ul class="navigation navigation-main">

    <!-- DASHBOARD -->
    <li class="nav-item <?= $currentPage==$dashboardLink?'active':'' ?>">
        <a href="<?= $dashboardLink ?>">
            <i class="icon-home3"></i>
            <span class="menu-title">Dashboard</span>
        </a>
    </li>

    <?php foreach($roleMenu as $item): ?>
        <?php if(isset($item['submenu'])): ?>
            <li class="nav-item <?= in_array($currentPage,array_column($item['submenu'],'link'))?'active':'' ?>">
                <a href="#">
                    <i class="<?= $item['icon'] ?>"></i>
                    <span class="menu-title"><?= $item['title'] ?></span>
                </a>
                <ul class="menu-content">
                    <?php foreach($item['submenu'] as $sub): ?>
                        <li>
                            <a href="<?= $sub['link'] ?>" class="menu-item <?= $currentPage==$sub['link']?'active':'' ?>">
                                <i class="<?= $sub['icon'] ?>"></i> <?= $sub['title'] ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </li>
        <?php else: ?>
            <li class="nav-item <?= $currentPage==$item['link']?'active':'' ?>">
                <a href="<?= $item['link'] ?>">
                    <i class="<?= $item['icon'] ?>"></i>
                    <span class="menu-title"><?= $item['title'] ?></span>
                </a>
            </li>
        <?php endif; ?>
    <?php endforeach; ?>

  </ul>
<br><br><br>
</div>