<?php
session_start();

// ---------------- Access Control ----------------
// Ensure user is logged in
if (!isset($_SESSION['user_role'])) {
    $_SESSION['flash'] = ["message" => "Please log in first!", "color" => "#dc3545"];
    header("Location: login.php");
    exit;
}

// Allow only Lab_technician role
if ($_SESSION['user_role'] !== 'Lab_technician') {
    $_SESSION['flash'] = ["message" => "Access denied! Only Lab_technicians allowed.", "color" => "#dc3545"];
    header("Location: login.php");
    exit;
}

// Optional: dynamic info
$username = $_SESSION['username'] ?? 'Lab_technician';
$facility = $_SESSION['user_facility_name'] ?? 'N/A';
?>

<?php include('includes/header.php'); ?>

<!-- navbar-fixed-top-->
<nav class="header-navbar navbar navbar-with-menu navbar-fixed-top navbar-semi-dark navbar-shadow">
  <?php include('includes/navbar.php'); ?>
</nav>

<!-- main menu-->
<div data-scroll-to-active="true" class="main-menu menu-fixed menu-dark menu-accordion menu-shadow">
  <?php include('includes/sidebar.php'); ?>
</div>

<div class="app-content content container-fluid">
  <div class="content-wrapper">
    <div class="content-header row">
      <div class="col-md-12">
        <h3 class="content-header-title">Lab_technician Dashboard</h3>
        <p>Welcome, <strong><?= htmlspecialchars($username) ?></strong> | Facility: <strong><?= htmlspecialchars($facility) ?></strong></p>
      </div>
    </div>

    <div class="content-body">
      <!-- Lab_technician-specific Stats / Cards -->
      <div class="row">
        <div class="col-md-4">
          <div class="card text-center p-3">
            <h4>My Patients</h4>
            <p>42</p> <!-- Replace with dynamic DB query -->
          </div>
        </div>
        <div class="col-md-4">
          <div class="card text-center p-3">
            <h4>Upcoming Appointments</h4>
            <p>7</p> <!-- Replace with dynamic DB query -->
          </div>
        </div>
        <div class="col-md-4">
          <div class="card text-center p-3">
            <h4>Pending Lab Results</h4>
            <p>5</p> <!-- Replace with dynamic DB query -->
          </div>
        </div>
      </div>
      <!-- / Lab_technician Stats -->

      <!-- Additional dynamic content (e.g., patient list, notifications) can go here -->

    </div>
  </div>
</div>

<?php include('includes/footer.php'); ?>
