<?php
session_start();

/* ================= Session Timeout (12 hours) ================= */
$SESSION_TIMEOUT = 43200; // 12 hours in seconds

if (isset($_SESSION['LAST_ACTIVITY'])) {
    if (time() - $_SESSION['LAST_ACTIVITY'] > $SESSION_TIMEOUT) {
        // Session expired
        session_unset();
        session_destroy();
        header("Location: login.php?timeout=1");
        exit;
    }
}

// Update last activity time
$_SESSION['LAST_ACTIVITY'] = time();

include('includes/db.php');

// ---------------- Access Control ----------------
if (!isset($_SESSION['user_role'])) {
    $_SESSION['flash'] = ["message" => "Please log in first!", "color" => "#dc3545"];
    header("Location: login.php");
    exit;
}

if ($_SESSION['user_role'] !== 'Nurse') {
    $_SESSION['flash'] = ["message" => "Access denied! Only Nurses allowed.", "color" => "#dc3545"];
    header("Location: login.php");
    exit;
}

// ---------------- Dynamic Info ----------------
$username = $_SESSION['username'] ?? 'Nurse';
$facility_name = $_SESSION['user_facility_name'] ?? 'N/A';

// ---------------- Dashboard Stats ----------------

// 1. Total Patients
$totalPatients = $pdo->query("SELECT COUNT(*) FROM patients")->fetchColumn() ?: 0;

// 2. Total Visits
$totalVisits = $pdo->query("SELECT COUNT(*) FROM visits")->fetchColumn() ?: 0;

// 3. Total Visit Tickets
$totalVisitTickets = $pdo->query("SELECT COUNT(*) FROM visit_tickets")->fetchColumn() ?: 0;

// 4. Upcoming Appointments (future visits)
$upcomingAppointments = $pdo->query("
    SELECT COUNT(*) 
    FROM visits 
    WHERE visit_date > NOW() AND status='open'
")->fetchColumn() ?: 0;

// 5. Pending Lab Results
$pendingLabResults = $pdo->query("
    SELECT COUNT(lo.id)
    FROM lab_orders lo
    JOIN visit_tickets vt ON vt.id = lo.visit_ticket_id
    JOIN visits v ON v.id = vt.visit_id
    WHERE lo.status='pending'
")->fetchColumn() ?: 0;

// 6. Recent Visits
$recentVisits = $pdo->query("
    SELECT v.visit_number, p.first_name, p.last_name, v.visit_date, v.status, v.id as visit_id
    FROM visits v
    JOIN patients p ON p.id = v.patient_id
    ORDER BY v.visit_date DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

?>

<?php include('includes/header.php'); ?>

<nav class="header-navbar navbar navbar-with-menu navbar-fixed-top navbar-semi-dark navbar-shadow">
  <?php include('includes/navbar.php'); ?>
</nav>

<div data-scroll-to-active="true" class="main-menu menu-fixed menu-dark menu-accordion menu-shadow">
  <?php include('includes/sidebar.php'); ?>
</div>

<div class="app-content content container-fluid">
  <div class="content-wrapper">
    <div class="content-header row">
      <div class="col-md-12">
        <h3 class="content-header-title">Nurse Dashboard</h3>
        <!--<p>Welcome, <strong><?= htmlspecialchars($username) ?></strong> | Facility: <strong><?= htmlspecialchars($facility_name) ?></strong></p>-->
      </div>
    </div>

    <div class="content-body">
      <div class="row">
        <div class="col-md-3">
          <div class="card text-center p-3">
            <h4>Total Patients</h4>
            <p><?= $totalPatients ?></p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card text-center p-3">
            <h4>Total Visits</h4>
            <p><?= $totalVisits ?></p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card text-center p-3">
            <h4>Total Visit Tickets</h4>
            <p><?= $totalVisitTickets ?></p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card text-center p-3">
            <h4>Upcoming Appointments</h4>
            <p><?= $upcomingAppointments ?></p>
          </div>
        </div>
      </div>

      <div class="row mt-4">
        <div class="col-md-12">
          <div class="card p-3">
            <h4>Pending Lab Results: <?= $pendingLabResults ?></h4>
            <h4 class="mt-3">Recent Visits</h4>
            <!--<table class="table table-bordered table-striped">-->
            <!--  <thead>-->
            <!--    <tr>-->
            <!--      <th>Visit Number</th>-->
            <!--      <th>Patient</th>-->
            <!--      <th>Visit Date</th>-->
            <!--      <th>Status</th>-->
            <!--      <th>Actions</th>-->
            <!--    </tr>-->
            <!--  </thead>-->
            <!--  <tbody>-->
            <!--  <?php foreach ($recentVisits as $visit): ?>-->
            <!--    <tr>-->
            <!--      <td><?= htmlspecialchars($visit['visit_number']) ?></td>-->
            <!--      <td><?= htmlspecialchars($visit['first_name'] . ' ' . $visit['last_name']) ?></td>-->
            <!--      <td><?= htmlspecialchars($visit['visit_date']) ?></td>-->
            <!--      <td><?= htmlspecialchars(ucfirst($visit['status'])) ?></td>-->
            <!--      <td><a href="visit_ticket.php?id=<?= $visit['visit_id'] ?>" class="btn btn-sm btn-primary">View</a></td>-->
            <!--    </tr>-->
            <!--  <?php endforeach; ?>-->
            <!--  </tbody>-->
            <!--</table>-->
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include('includes/footer.php'); ?>
