<?php
include('includes/web_header.php');
include('include/db.php'); // PDO connection

// ==================== Fetch only 3 latest services ====================
$stmt = $pdo->prepare("SELECT * FROM services WHERE status='enabled' ORDER BY created_at ASC ");
$stmt->execute();
$services = $stmt->fetchAll();

?>

<!-- Navbar Start -->
<div class="container-fluid sticky-top">
    <?php include('includes/web_navbar.php'); ?>
</div>
<!-- Navbar End -->

<!-- Page Header Start -->
    <div class="container-fluid page-header py-5 wow fadeIn" data-wow-delay="0.1s">
        <div class="container text-center py-5 mt-4">
            <h1 class="display-2 text-white mb-3 animated slideInDown">Services</h1>
        </div>
    </div>
    <!-- Page Header End -->

<!-- Services Start -->
<div class="container-fluid container-service py-5">
    <div class="container pt-5">
        <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
            <h1 class="display-6 mb-3">Reliable & High-Quality Medical Service</h1>
            <p class="mb-5">We provide comprehensive medical services using state-of-the-art technology and expert analysis.</p>
        </div>

        <div class="row g-4">
            <?php
            if(count($services) > 0) {
                $count = 0;
                foreach($services as $service) {
                    $count++;
                    $delay = 0.1 + (($count % 4) * 0.2);
                    if($delay > 0.7) $delay = 0.7;

                    // Truncate description to 20 words (like team section)
                    $desc_words = str_word_count(strip_tags($service['description']), 1);
                    $short_desc = implode(' ', array_slice($desc_words, 0, 20));
                    $is_truncated = count($desc_words) > 20;
                    
                    if ($is_truncated) {
                        $short_desc .= '...';
                    }

                    $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
            ?>
            <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="<?php echo $delay; ?>s">
                <div class="service-item">
                    <div class="position-relative overflow-hidden mb-3">
                        <img class="img-fluid w-100 rounded" src="<?php echo htmlspecialchars($image_path); ?>" alt="<?php echo htmlspecialchars($service['title']); ?>" style="height: 200px; object-fit: cover;">
                    </div>
                    <h5 class="mb-3 service-title"><?php echo htmlspecialchars($service['title']); ?></h5>
                    <p class="service-desc mb-3">
                        <?php echo nl2br(htmlspecialchars($short_desc)); ?>
                    </p>
                    <?php if($is_truncated): ?>
                    <button class="btn btn-outline-primary btn-sm read-more-btn" data-bs-toggle="modal" data-bs-target="#serviceModal<?php echo $service['id']; ?>">
                        Read More <i class="bi bi-chevron-double-right ms-1"></i>
                    </button>
                    <?php else: ?>
                    <button class="btn btn-outline-primary btn-sm read-more-btn" data-bs-toggle="modal" data-bs-target="#serviceModal<?php echo $service['id']; ?>">
                        View Details <i class="bi bi-info-circle ms-1"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php
                }
            } else {
            ?>
            <div class="col-12 text-center">
                <div class="alert alert-info">
                    <h5>No services available at the moment.</h5>
                    <p>Please check back later for our service offerings.</p>
                </div>
            </div>
            <?php } ?>
        </div>

       
    </div>
</div>
<!-- Services End -->

<!-- Service Modals -->
<?php foreach($services as $service): 
    $image_path = !empty($service['image_path']) ? $service['image_path'] : 'asset/img/service-default.jpg';
?>
<div class="modal fade" id="serviceModal<?php echo $service['id']; ?>" tabindex="-1" aria-labelledby="serviceModalLabel<?php echo $service['id']; ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel<?php echo $service['id']; ?>"><?php echo htmlspecialchars($service['title']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-5">
                        <img src="<?php echo htmlspecialchars($image_path); ?>" class="img-fluid rounded mb-3" alt="<?php echo htmlspecialchars($service['title']); ?>" style="max-height: 300px; object-fit: cover; width: 100%;">
                    </div>
                    <div class="col-md-7">
                        <h6 class="text-primary mb-3">Service Overview</h6>
                        <div class="service-full-desc mb-4">
                            <?php echo nl2br(htmlspecialchars($service['description'])); ?>
                        </div>
                        
                        <?php if(!empty($service['detail'])): ?>
                        <h6 class="text-primary mb-3">Detailed Information</h6>
                        <div class="service-full-detail">
                            <?php echo $service['detail']; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>


<style>
/* Service Item Styling */
.service-item {
    transition: all 0.3s ease;
    border: 1px solid #eee;
    border-radius: 8px;
    overflow: hidden;
    padding: 1.5rem;
    height: 100%;
    display: flex;
    flex-direction: column;
    background: white;
}

.service-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    background-color: #0d6efd !important; /* Blue background on hover */
}

/* Title and description color changes on hover */
.service-item:hover .service-title {
    color: white !important;
}

.service-item:hover .service-desc {
    color: white !important;
}

/* Description styling */
.service-desc {
    min-height: 80px;
    overflow: hidden;
    line-height: 1.6;
    color: #666;
    font-size: 0.95rem;
    transition: color 0.3s ease;
}

.service-title {
    color: #2c3e50;
    transition: color 0.3s ease;
}

.service-full-desc,
.service-full-detail {
    line-height: 1.8;
    color: #555;
}

/* Read More Button Styling - White text on blue background by default */
.read-more-btn {
    border-color: #0d6efd;
    color: #0d6efd;
    background-color: transparent;
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 4px;
    transition: all 0.3s ease;
    border-width: 2px;
    margin-top: auto; /* Push button to bottom */
}

/* Button on hover (when service card has blue background) */
.service-item:hover .read-more-btn {
    background-color: white !important;
    color: #0d6efd !important;
    border-color: white !important;
}

/* Button hover state (when service card doesn't have blue background) */
.service-item:not(:hover) .read-more-btn:hover {
    background-color: #0d6efd !important;
    color: white !important;
    border-color: #0d6efd !important;
}

.read-more-btn:active,
.read-more-btn:focus {
    outline: none;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25) !important;
}

/* Icon color changes */
.service-item:hover .read-more-btn i {
    color: #0d6efd !important;
}

.service-item:not(:hover) .read-more-btn:hover i {
    color: white !important;
}

/* Main Explore More Button */
.explore-more-btn {
    background-color: #0d6efd;
    border-color: #0d6efd;
    transition: all 0.3s ease;
    color: white;
}

.explore-more-btn:hover {
    background-color: #0b5ed7;
    border-color: #0a58ca;
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
    color: white;
}

/* Modal Styling */
.modal-content {
    border-radius: 10px;
    overflow: hidden;
}

.modal-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
    padding: 1rem 1.5rem;
}

.modal-body {
    padding: 1.5rem;
}

.modal-title {
    color: #2c3e50;
    font-weight: 600;
}

/* Team Item Styling */
.team-item {
    transition: all 0.3s ease;
    border: 1px solid #eee;
    border-radius: 8px;
    overflow: hidden;
    background: white;
    height: 100%;
}

.team-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.team-item img {
    height: 250px;
    object-fit: cover;
}

.team-social {
    position: absolute;
    bottom: -100%;
    left: 0;
    width: 100%;
    background: rgba(0, 0, 0, 0.7);
    padding: 1rem;
    text-align: center;
    transition: bottom 0.3s ease;
}

.team-item:hover .team-social {
    bottom: 0;
}

.member-bio {
    min-height: 60px;
    overflow: hidden;
}

.member-full-bio {
    line-height: 1.8;
    color: #555;
}

/* Insurance Companies Styling */
.feature-item {
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.feature-item:hover {
    transform: scale(1.05);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.feature-item img {
    max-height: 60px;
    object-fit: contain;
}

@media (max-width: 768px) {
    .service-item {
        padding: 1rem;
    }
    
    .service-item img {
        height: 180px;
    }
    
    .service-desc {
        min-height: 100px;
        font-size: 0.9rem;
    }
    
    .modal-body .row {
        flex-direction: column;
    }
    
    .modal-body .col-md-5 {
        margin-bottom: 1.5rem;
    }
    
    .read-more-btn {
        width: 100%;
        padding: 0.5rem;
    }
    
    .team-item img {
        height: 200px;
    }
    
    .team-social {
        padding: 0.5rem;
    }
    
    .feature-item {
        padding: 2rem !important;
    }
    
    .feature-item img {
        max-height: 40px;
    }
}
</style>

<script>
// CEO Bio Toggle
document.addEventListener('DOMContentLoaded', function() {
    const toggleBtn = document.getElementById('ceo-bio-toggle');
    if(toggleBtn) {
        toggleBtn.addEventListener('click', function() {
            const shortBio = document.getElementById('ceo-bio-short');
            const fullBio = document.getElementById('ceo-bio-full');
            if(fullBio.classList.contains('d-none')) {
                shortBio.classList.add('d-none');
                fullBio.classList.remove('d-none');
                toggleBtn.textContent = 'Read Less';
            } else {
                fullBio.classList.add('d-none');
                shortBio.classList.remove('d-none');
                toggleBtn.textContent = 'Read More';
            }
        });
    }
});
</script>

<?php include('includes/web_footer.php'); ?>