## 8.0.0 - 2025-07-23

### Added
- New `pageUid` property on the `tinymce` global instance. #TINY-12021
- New `editorUid` property on editor instances. #TINY-12021
- New `UserLookup` API to provide consistent user management and fetching/caching user information across TinyMCE plugins. #TINY-11974
- New toolbar icons for suggested edits plugin. #TINY-12070
- New `crossorigin` option that sets the `crossorigin` attribute on scripts loaded by the editor. #TINY-12228
- New `allow_html_in_comments` option to allow HTML like contents inside comment data. #TINY-12220
- New `list_max_depth` option that limits the maximum list indent depth. #TINY-11937
- Support for TinyMCE 8 license keys and license key manager. #TINY-12001

### Improved
- Focus is now restored to a dialog after closing an alert, confirmation or another dialog. #TINY-12038
- Resize handles are more accessible with `role` and `aria-valuetext` attributes. #TINY-11421
- Toolbar drawer now closes when the editor loses focus. #TINY-12125
- The `translate` API now automatically replaces three dots in a row with an ellipsis character. #TINY-12155
- Tooltips can now be closed by pressing the escape key. #TINY-12054
- Instructions on how to navigate the color swatch, image select and insert table widget are now announced by the screen readers. #TINY-12189
- When `editor.resetContent()` is used, the resulting `SetContent` event now has the `initial` flag set in the event arguments. #TINY-12146
- Updated Image plugin decorative image check to align with accessibility standard #TINY-12545

### Changed
- DomParser no longer tries to fix some nodes when parsed with a context. #TINY-11927
- Split buttons are now rendered as separate action and chevron buttons. #TINY-8665
- Moved essential parts of the `lists` plugin into core. #TINY-12121
- Cut action now uses the editor delete implementation instead of the native `execCommand('Delete')` function. #TINY-12171
- Comments with HTML like content, attributes with HTML like values, elements with HTML Comment like textContent are no longer retained while content sanitization is active. #TINY-12056
- Added space to promotion message for ease of reading. #TINY-12271

### Deprecated
- Deprecated `skipFocus` option for ToggleToolbarDrawer command. To skip focus use `skip_focus` option. #TINY-12044
- Deprecated 'editor.selection.setContent' method. #TINY-11692

### Removed
- Removed undocumented `documentBaseUrl` property from `Editor` instances. `documentBaseURI` is the supported property. #TINY-12182

### Fixed
- Long tooltips could overflow narrow browser windows. #TINY-11884
- Pressing Tab to create a new row in tables with a non-editable final row would freeze the editor. #TINY-12018
- Fixed an issue where the context form API `onSetup` was referencing the incorrect element. #TINY-11912
- Attempting to add a newline directly after a block element such as an image would cause an error. #TINY-12045
- It wasn't possible to navigate out of a `figcaption` using the left and right arrow keys in Firefox. #TINY-11982
- Nested font sizes were causing too much spacing between lines. #TINY-12073
- New list item was not inserted correctly when existing list item had a block element inside. #TINY-12102
- Deleting a whole element would sometimes replace the tag name of adjacent content. #TINY-11868
- HTML schema did not treat `colgroup` or `col` elements as block elements. #TINY-12092
- Inserting HTML fragments with invalid contents now retains more of the structure. #TINY-11927
- The `contextform` subtoolbar is no longer dismissed when using the toolbar back button in inline editors. #TINY-12118
- Tabbing when a `figure` was selected didn't move the selection on the `figcaption` correctly. #TINY-11753
- Strikethrough format could be added outside font size format, which renders incorrectly in some browsers. #TINY-12004
- Using arrow navigation between buttons when a button had the mouse over could stop the navigation. #TINY-12163
- Codesample dialog would not disable spellcheck as expected. #TINY-12120
- Cutting a whole HTML element would add an empty paragraph. #TINY-12171
- Added better support for template elements. #TINY-12157
- Tooltips no longer show above editor views. #TINY-12289
- `onboarding` plugin overlay now shows above popups. #TINY-12522
