import { type FieldProcessor, FieldSchema, StructureSchema, ValueType } from '@ephox/boulder';
import type { Result } from '@ephox/katamari';

import * as ComponentSchema from '../../core/ComponentSchema';

import { type FormComponentWithLabel, formComponentWithLabelFields, type FormComponentWithLabelSpec } from './FormComponent';

export interface SelectBoxItemSpec {
  text: string;
  value: string;
}

export interface SelectBoxSpec extends FormComponentWithLabelSpec {
  type: 'selectbox';
  items: SelectBoxItemSpec[];
  size?: number;
  enabled?: boolean;
  context?: string;
}

export interface SelectBoxItem {
  text: string;
  value: string;
}

export interface SelectBox extends FormComponentWithLabel {
  type: 'selectbox';
  items: SelectBoxItem[];
  size: number;
  enabled: boolean;
  context: string;
}

const selectBoxFields: FieldProcessor[] = formComponentWithLabelFields.concat([
  FieldSchema.requiredArrayOfObj('items', [
    ComponentSchema.text,
    ComponentSchema.value
  ]),
  FieldSchema.defaultedNumber('size', 1),
  ComponentSchema.enabled,
  FieldSchema.defaultedString('context', 'mode:design')
]);

export const selectBoxSchema = StructureSchema.objOf(selectBoxFields);

export const selectBoxDataProcessor = ValueType.string;

export const createSelectBox = (spec: SelectBoxSpec): Result<SelectBox, StructureSchema.SchemaError<any>> =>
  StructureSchema.asRaw<SelectBox>('selectbox', selectBoxSchema, spec);
