import { Bem } from 'oxide-components/main';
import type { FunctionComponent } from 'react';

interface SpinnerProps {
  type?: 'circle' | 'dots';
}

export const Spinner: FunctionComponent<SpinnerProps> = ({ type = 'circle' }) =>
  <div className={Bem.element('tox-ai', 'spinner', { dots: type === 'dots', circle: type === 'circle' })}>
    { type === 'dots' ? (
      <>
        <div></div>
        <div></div>
        <div></div>
      </>
    ) : (
      <svg
        xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
        {/* eslint-disable-next-line max-len */}
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.4027 5.42525C12.8001 4.83962 11.0388 4.85946 9.44985 5.48105C7.86089 6.10264 6.55366 7.28318 5.77386 8.80077C4.99407 10.3184 4.7954 12.0685 5.2152 13.7223C5.635 15.3761 6.64436 16.8196 8.05357 17.7815C9.46278 18.7434 11.1748 19.1575 12.8679 18.946C14.5609 18.7345 16.1184 17.9119 17.2476 16.6328C18.3768 15.3537 19 13.7062 19 12V11H21V12C21 14.1937 20.1988 16.3119 18.7469 17.9564C17.2951 19.601 15.2926 20.6586 13.1158 20.9306C10.939 21.2025 8.73785 20.6701 6.92601 19.4333C5.11417 18.1966 3.81642 16.3406 3.27668 14.2144C2.73694 12.0881 2.99237 9.8379 3.99496 7.88671C4.99756 5.93552 6.67828 4.41769 8.72123 3.6185C10.7642 2.81931 13.0287 2.7938 15.0891 3.54675C16.1067 3.91863 17.04 4.46776 17.85 5.16059C18.2697 5.51958 18.3189 6.15083 17.9599 6.57053C17.601 6.99023 16.9697 7.03945 16.55 6.68046C15.92 6.14156 15.1941 5.71449 14.4027 5.42525Z" />
      </svg>
    )}
  </div>;
