import AddOnManager from './AddOnManager';
import type Editor from './Editor';
import type { NotificationManagerImpl } from './NotificationManager';
import type { EditorUiApi } from './ui/Ui';
import type { WindowManagerImpl } from './WindowManager';

export interface RenderResult {
  iframeContainer?: HTMLElement;
  editorContainer: HTMLElement;
  api?: Partial<EditorUiApi>;
}

export interface Theme {
  ui?: any;
  inline?: any;
  execCommand?: (command: string, ui?: boolean, value?: any) => boolean;
  destroy?: () => void;
  init?: (editor: Editor, url: string) => void;
  renderUI?: () => Promise<RenderResult> | RenderResult;
  getNotificationManagerImpl?: () => NotificationManagerImpl;
  getWindowManagerImpl?: () => WindowManagerImpl;
  getPromotionElement?: () => HTMLElement | null;
  getSinkElement?: (type: 'dialog' | 'popup') => HTMLElement;
}

type ThemeManager = AddOnManager<void | Theme>;
const ThemeManager: ThemeManager = AddOnManager.ThemeManager;

export default ThemeManager;
