import { type AlloyComponent, Disabling, type ItemTypes } from '@ephox/alloy';
import type { Menu } from '@ephox/bridge';
import { Optional } from '@ephox/katamari';

import type { UiFactoryBackstageProviders } from 'tinymce/themes/silver/backstage/Backstage';

import type ItemResponse from '../ItemResponse';
import { renderItemStructure } from '../structure/ItemStructure';

import { buildData, renderCommonItem } from './CommonMenuItem';

// Note, this does not create a valid SketchSpec.
const renderNormalItem = (spec: Menu.MenuItem, itemResponse: ItemResponse, providersBackstage: UiFactoryBackstageProviders, renderIcons: boolean = true): ItemTypes.ItemSpec => {
  const getApi = (component: AlloyComponent): Menu.MenuItemInstanceApi => ({
    isEnabled: () => !Disabling.isDisabled(component),
    setEnabled: (state: boolean) => Disabling.set(component, !state)
  });

  const structure = renderItemStructure({
    presets: 'normal',
    iconContent: spec.icon,
    textContent: spec.text,
    htmlContent: Optional.none(),
    labelContent: Optional.none(),
    ariaLabel: spec.text,
    caret: Optional.none(),
    checkMark: Optional.none(),
    shortcutContent: spec.shortcut
  }, providersBackstage, renderIcons);

  return renderCommonItem({
    context: spec.context,
    data: buildData(spec),
    getApi,
    enabled: spec.enabled,
    onAction: spec.onAction,
    onSetup: spec.onSetup,
    triggersSubmenu: false,
    itemBehaviours: []
  }, structure, itemResponse, providersBackstage);
};

export { renderNormalItem };
